(function($) {
  $.fn.findAndHighlight = function(str, options){
    options = $.extend({}, $.fn.findAndHighlight.options, options);
    this.each(function(){
      if(str == '') return;
      var text = $(this).text();
      
      var regexOpt = '';
      if(!options.caseSensitive){
        regexOpt += 'i';
      }
      if(!options.firstOnly){
        regexOpt += 'g';
      }
      
      var re = new RegExp("("+str+")", regexOpt);
      text = text.replace(re, "<span>$1</span>");
      
      $(this).html(text);
    });
    return this.find('span').css('backgroundColor', function(ind, val){
      var color = options.getColor(ind);
      if(!color){
        color = options.color;
      }
      return color;
    });
  };
  $.fn.findAndHighlight.options = {
    caseSensitive : true,
    firstOnly : false, 
    color : 'yellow',
    getColor : function(ind){
      return false;
    }
  }
  $.fn.resetHighlight = function(){
    return this.each(function(){
      var text = $(this).text();
      var re = new RegExp("</?span>","gi");
      text = text.replace(re, "");
      $(this).html(text);
    });
  };
})(jQuery);
